/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.http;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.microedition.io.HttpConnection;
import org.microemu.microedition.io.ConnectionImplementation;

public class Connection
implements HttpConnection,
ConnectionImplementation {
    protected URLConnection cn;
    protected boolean connected = false;
    protected static boolean allowNetworkConnection = true;

    public javax.microedition.io.Connection openConnection(String object, int n2, boolean bl2) {
        if (!Connection.isAllowNetworkConnection()) {
            throw new IOException("No network");
        }
        try {
            object = new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.toString());
        }
        this.cn = ((URL)object).openConnection();
        this.cn.setDoOutput(true);
        if (this.cn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.cn).setInstanceFollowRedirects(false);
        }
        return this;
    }

    public void close() {
        if (this.cn == null) {
            return;
        }
        if (this.cn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.cn).disconnect();
        }
        this.cn = null;
    }

    public String getURL() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().toString();
    }

    public String getProtocol() {
        return "http";
    }

    public String getHost() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().getHost();
    }

    public String getFile() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().getFile();
    }

    public String getRef() {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getURL().getRef();
    }

    public String getQuery() {
        if (this.cn == null) {
            return null;
        }
        return null;
    }

    public int getPort() {
        if (this.cn == null) {
            return -1;
        }
        int n2 = this.cn.getURL().getPort();
        if (n2 == -1) {
            return 80;
        }
        return n2;
    }

    public String getRequestMethod() {
        if (this.cn == null) {
            return null;
        }
        if (this.cn instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.cn).getRequestMethod();
        }
        return null;
    }

    public void setRequestMethod(String string) {
        if (this.cn == null) {
            throw new IOException();
        }
        if (string.equals("POST")) {
            this.cn.setDoOutput(true);
        }
        if (this.cn instanceof HttpURLConnection) {
            ((HttpURLConnection)this.cn).setRequestMethod(string);
        }
    }

    public String getRequestProperty(String string) {
        if (this.cn == null) {
            return null;
        }
        return this.cn.getRequestProperty(string);
    }

    public void setRequestProperty(String string, String string2) {
        if (this.cn == null || this.connected) {
            throw new IOException();
        }
        this.cn.setRequestProperty(string, string2);
    }

    public int getResponseCode() {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        if (this.cn instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.cn).getResponseCode();
        }
        return -1;
    }

    public String getResponseMessage() {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        if (this.cn instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.cn).getResponseMessage();
        }
        return null;
    }

    public long getExpiration() {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getExpiration();
    }

    public long getDate() {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getDate();
    }

    public long getLastModified() {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getLastModified();
    }

    public String getHeaderField(String string) {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderField(string);
    }

    public int getHeaderFieldInt(String string, int n2) {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderFieldInt(string, n2);
    }

    public long getHeaderFieldDate(String string, long l2) {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderFieldDate(string, l2);
    }

    public String getHeaderField(int n2) {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderField(this.a(n2));
    }

    public String getHeaderFieldKey(int n2) {
        if (this.cn == null) {
            throw new IOException();
        }
        if (!this.connected) {
            this.cn.connect();
            this.connected = true;
        }
        return this.cn.getHeaderFieldKey(this.a(n2));
    }

    private int a(int n2) {
        if (this.cn.getHeaderFieldKey(0) == null && this.cn.getHeaderField(0) != null) {
            ++n2;
        }
        return n2;
    }

    public InputStream openInputStream() {
        if (this.cn == null) {
            throw new IOException();
        }
        this.connected = true;
        return this.cn.getInputStream();
    }

    public DataInputStream openDataInputStream() {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() {
        if (this.cn == null) {
            throw new IOException();
        }
        this.connected = true;
        return this.cn.getOutputStream();
    }

    public DataOutputStream openDataOutputStream() {
        return new DataOutputStream(this.openOutputStream());
    }

    public String getType() {
        try {
            return this.getHeaderField("content-type");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getEncoding() {
        try {
            return this.getHeaderField("content-encoding");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public long getLength() {
        try {
            return this.getHeaderFieldInt("content-length", -1);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public static boolean isAllowNetworkConnection() {
        return allowNetworkConnection;
    }

    public static void setAllowNetworkConnection(boolean bl2) {
        allowNetworkConnection = bl2;
    }
}

