/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.app.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.microemu.app.classloader.ClassPreprocessor;
import org.microemu.app.classloader.InstrumentationConfig;
import org.microemu.app.classloader.MIDletClassLoaderConfig;
import org.microemu.app.util.IOUtils;
import org.microemu.log.Logger;

public class MIDletClassLoader
extends URLClassLoader {
    public static boolean instrumentMIDletClasses = true;
    public static boolean traceClassLoading = false;
    public static boolean traceSystemClassLoading = false;
    public static boolean enhanceCatchBlock = false;
    public static final boolean debug = false;
    private boolean a = false;
    private boolean b = false;
    private InstrumentationConfig c;
    private Set d = new HashSet();
    private AccessControlContext e = AccessController.getContext();

    public MIDletClassLoader(ClassLoader classLoader) {
        super(new URL[0], classLoader);
        this.c = new InstrumentationConfig();
        this.c.setEnhanceCatchBlock(enhanceCatchBlock);
        this.c.setEnhanceThreadCreation(true);
    }

    public void configure(MIDletClassLoaderConfig mIDletClassLoaderConfig, boolean bl2) {
        Iterator iterator = mIDletClassLoaderConfig.b.iterator();
        while (iterator.hasNext()) {
            Object object = (String)iterator.next();
            object = new StringTokenizer((String)object, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.addURL(new URL(IOUtils.getCanonicalFileClassLoaderURL(new File(((StringTokenizer)object).nextToken()))));
            }
        }
        iterator = mIDletClassLoaderConfig.a.iterator();
        while (iterator.hasNext()) {
            this.addClassURL((String)iterator.next());
        }
        int n2 = mIDletClassLoaderConfig.getDelegationType(bl2);
        this.a = n2 == 2;
        this.b = n2 == 1;
    }

    public void addClassURL(String string) {
        String string2 = MIDletClassLoader.getClassResourceName(string);
        URL uRL = this.getParent().getResource(string2);
        if (uRL == null) {
            uRL = this.getResource(string2);
        }
        if (uRL == null) {
            throw new MalformedURLException("Unable to find class " + string + " URL");
        }
        string = uRL.toExternalForm();
        this.addURL(new URL(string.substring(0, string.length() - string2.length())));
    }

    public void addURL(URL uRL) {
        super.addURL(uRL);
    }

    protected synchronized Class loadClass(String string, boolean bl2) {
        Class<?> clazz;
        block5: {
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    clazz = this.findClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException2 = classNotFoundException;
                    if (!(classNotFoundException instanceof ay) && !this.a) break block5;
                    if (traceSystemClassLoading) {
                        Logger.info("Load system class", string);
                    }
                    if ((clazz = super.loadClass(string, false)) != null) break block5;
                    throw new ClassNotFoundException(string);
                }
            }
        }
        if (bl2) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public URL getResource(String string) {
        try {
            return (URL)AccessController.doPrivileged(new au(this, string), this.e);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public InputStream getResourceAsStream(String object) {
        if ((object = this.getResource((String)object)) == null) {
            return null;
        }
        try {
            return (InputStream)AccessController.doPrivileged(new av(this, (URL)object), this.e);
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public boolean classLoadByParent(String string) {
        if (string.startsWith("java.")) {
            return true;
        }
        if (string.startsWith("sun.reflect.")) {
            return true;
        }
        if (string.startsWith("javax.microedition.")) {
            return true;
        }
        if (string.startsWith("javax.")) {
            return true;
        }
        return this.d.contains(string);
    }

    public void disableClassPreporcessing(Class clazz) {
        this.disableClassPreporcessing(clazz.getName());
    }

    public void disableClassPreporcessing(String string) {
        this.d.add(string);
    }

    public static String getClassResourceName(String string) {
        return string.replace('.', '/').concat(".class");
    }

    protected Class findClass(String string) {
        int n2;
        byte[] byArray;
        InputStream inputStream;
        block21: {
            block20: {
                if (this.classLoadByParent(string)) {
                    throw new ay(string);
                }
                try {
                    boolean bl2;
                    inputStream = (InputStream)AccessController.doPrivileged(new aw(this, string), this.e);
                    if (inputStream != null || !this.b) break block20;
                    try {
                        this.addClassURL(string);
                        bl2 = true;
                    }
                    catch (MalformedURLException malformedURLException) {
                        bl2 = false;
                    }
                    if (bl2) {
                        inputStream = (InputStream)AccessController.doPrivileged(new ax(this, string), this.e);
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new ClassNotFoundException(string, privilegedActionException.getCause());
                }
            }
            if (inputStream == null) {
                throw new ClassNotFoundException(string);
            }
            try {
                if (traceClassLoading) {
                    Logger.info("Load MIDlet class", string);
                }
                if (instrumentMIDletClasses) {
                    byArray = ClassPreprocessor.instrument(inputStream, this.c);
                    n2 = byArray.length;
                    break block21;
                }
                byArray = new byte[2048];
                n2 = 0;
                while (true) {
                    int n3;
                    try {
                        n3 = inputStream.read(byArray, n2, byArray.length - n2);
                    }
                    catch (IOException iOException) {
                        throw new ClassNotFoundException(string, iOException);
                    }
                    if (n3 == -1) break block21;
                    if (byArray.length + 2048 > 16384) {
                        throw new ClassNotFoundException(string, new ClassFormatError("Class object is bigger than 16 Kilobyte"));
                    }
                    if (byArray.length == (n2 += n3)) {
                        byte[] byArray2 = new byte[byArray.length + 2048];
                        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                        byArray = byArray2;
                        continue;
                    }
                    if (byArray.length < n2) break;
                }
                throw new ClassNotFoundException(string, new ClassFormatError("Internal read error"));
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return this.defineClass(string, byArray, 0, n2);
    }

    public static boolean a(MIDletClassLoader mIDletClassLoader) {
        return mIDletClassLoader.a;
    }
}

